# Развертывание RAG Chat API и Analytics

Что есть и как запустить. Только то что реально нужно.

## Что в коробке

Два сервиса:

RAG Chat API - основной чат-бот который отвечает на вопросы пользователей.

Analytics - собирает статистику по диалогам, показывает кто что спрашивал и как быстро отвечала модель.

Оба на Flask, работают независимо друг от друга, но обычно используются вместе.

## Балансировщики на удаленном кластере

В проекте используются балансировщики Nginx на удаленном кластере для Ollama и Reranker.

Ollama балансировщик работает на внешнем IP адресе, порт 11436. Балансирует запросы между несколькими инстансами Ollama используя алгоритм least_conn. OLLAMA_BASE_URL должен указывать на этот балансировщик.

Reranker балансировщик работает на внешнем IP адресе, путь /reranker/. Балансирует запросы между несколькими инстансами реранкера. RERANKER_SERVICE_URLS должен указывать на этот балансировщик.

Если балансировщики недоступны, можно указать несколько прямых адресов через запятую - система будет переключаться между ними при ошибках.

## Что нужно перед запуском

Обязательно:
- Docker и docker-compose версия 2+ желательно но старые работают
- Python 3.9 или новее если запускаешь без Docker
- Доступ к Ollama балансировщику на удаленном кластере или прямые адреса Ollama серверов
- ChromaDB - векторная база для документов. Можно поднять отдельно или в Docker
- Доступ к Reranker балансировщику на удаленном кластере или прямые адреса реранкера

Желательно:
- Nginx для проксирования если планируешь HTTPS
- SSL сертификаты Let's Encrypt вполне подойдет
- Хотя бы 4GB RAM свободных модели жрут память

## Быстрый старт

Вариант 1: Docker рекомендуется

Если у тебя уже есть Ollama балансировщик и ChromaDB где-то работают:

RAG Chat API:
cd rag-chat-api
docker build -t rag-chat-api .
docker run -d -p 9004:9004 -e OLLAMA_BASE_URL=http://YOUR_EXTERNAL_IP:11436/ -e CHROMADB_BASE_URL=http://YOUR_INTERNAL_IP:8000 -e RERANKER_SERVICE_URLS=http://YOUR_EXTERNAL_IP/reranker/ -e MODEL_NAME=qwen3:30b -e EMBEDDING_MODEL=jeffh/intfloat-multilingual-e5-large-instruct:q8_0 rag-chat-api

Analytics:
cd ../analytics
docker build -t analytics .
docker run -d -p 9005:9005 -v $(pwd)/data:/app/data analytics

Вариант 2: Без Docker

RAG Chat API:
cd rag-chat-api
pip install -r requirements.txt
export OLLAMA_BASE_URL=http://YOUR_EXTERNAL_IP:11436/
export CHROMADB_BASE_URL=http://YOUR_INTERNAL_IP:8000
export RERANKER_SERVICE_URLS=http://YOUR_EXTERNAL_IP/reranker/
export MODEL_NAME=qwen3:30b
python app.py

Analytics в другом терминале:
cd analytics
pip install -r requirements.txt
python app.py

## Переменные окружения

Основные переменные для RAG Chat API:

OLLAMA_BASE_URL=http://YOUR_EXTERNAL_IP:11436/
CHROMADB_BASE_URL=http://YOUR_INTERNAL_IP:8000
ANALYTICS_BASE_URL=http://YOUR_ANALYTICS_IP:9005
RERANKER_SERVICE_URLS=http://YOUR_EXTERNAL_IP/reranker/
MODEL_NAME=qwen3:30b
EMBEDDING_MODEL=jeffh/intfloat-multilingual-e5-large-instruct:q8_0
TEMPERATURE=0.2
NUM_CTX=50000
SEARCH_K=100
TIMEOUT=600

OLLAMA_BASE_URL может содержать несколько адресов через запятую для балансировки. Если указан балансировщик на удаленном кластере - используй его адрес с портом 11436.

RERANKER_SERVICE_URLS может содержать несколько адресов через запятую. Если указан балансировщик на удаленном кластере - используй его адрес с путем /reranker/.

Можно задать через .env файл или прямо в docker run через -e. Как удобнее.

## Порты

По умолчанию:
- RAG Chat API слушает на 9004
- Analytics на 9005

Можешь поменять через переменную FLASK_PORT или в коде если нужно.

## Первый запуск

После того как все поднялось:

1. Проверь что API отвечает: curl http://localhost:9004/api/status
2. Загрузи документы через админку: http://localhost:9004/admin
3. Проверь что виджет работает: http://localhost:9004/widget-demo

Если что-то не работает - смотри логи. Обычно там все понятно написано.

## Настройка виджета

Встраивается одной строкой:

<script src="http://YOUR_API_URL/static/widget.js" data-api-url="http://YOUR_API_URL"></script>

Все. Больше ничего не нужно. Виджет сам подтянет стили и начнет работать.

Если нужно кастомизировать - смотри static/widget.js там все настройки в начале файла.

## База данных аналитики

Analytics использует SQLite по умолчанию. Файл базы лежит в analytics/data/analytics.db.

Если нужно перенести на PostgreSQL или MySQL - меняй код в analytics/app.py там все просто.

## Проблемы и решения

API не отвечает:
- Проверь что Ollama балансировщик доступен по указанному адресу
- Посмотри логи контейнера: docker logs <container_id>
- Убедись что порт не занят другим процессом
- Если используешь балансировщик - проверь что он работает и доступен

Виджет не загружается:
- Проверь CORS настройки по умолчанию все разрешено
- Убедись что data-api-url указан правильно
- Открой консоль браузера там обычно написано что не так

Медленные ответы:
- Увеличь TIMEOUT если модель долго думает
- Проверь что Ollama балансировщик не перегружен
- Можешь уменьшить NUM_CTX если контекст слишком большой
- Если используешь балансировщик - проверь что все инстансы Ollama работают

Документы не находятся:
- Проверь что ChromaDB работает и доступен
- Убедись что документы загружены через админку
- Посмотри логи там видно сколько документов найдено

Реранкинг не работает:
- Проверь что Reranker балансировщик доступен по указанному адресу
- Если используешь балансировщик - проверь что он работает и все инстансы реранкера доступны
- Посмотри логи reranker_client там видно какие адреса пробуются

## Что дальше

После того как все работает:
1. Настрой Nginx для HTTPS если нужно
2. Загрузи свои документы в систему
3. Настрой системный промпт под свои нужды production_configs/system_prompt.txt
4. Мониторь логи и статистику через Analytics

Все. Больше ничего особенного нет. Если что-то не работает - пиши в issues или разбирайся по логам.
