# RAG Chat API и Analytics

Система для создания чат-бота который отвечает на вопросы используя твои документы.

## Что это

Два сервиса:

RAG Chat API - принимает вопросы, ищет документы в базе, отправляет в модель, возвращает ответ.

Analytics - собирает диалоги, считает статистику, показывает графики.

Могут работать вместе или отдельно. Если аналитика не нужна - просто не запускай ее.

## Как работает

Пользователь задает вопрос. API ищет похожие документы в ChromaDB. Найденное отправляется в модель вместе с вопросом. Модель генерирует ответ на основе документов. Ответ возвращается пользователю.

Все происходит в реальном времени через SSE, пользователь видит как ответ генерируется по частям.

## Архитектура

Пользователь -> Виджет -> RAG Chat API -> ChromaDB (поиск документов)
                                    |
                              Ollama (генерация ответа через балансировщик)
                                    |
                              Reranker (улучшение релевантности через балансировщик)
                                    |
                              Analytics (статистика)

Все сервисы независимые. Можешь запустить только API, можешь все вместе, можешь несколько экземпляров за балансировщиком.

## Балансировщики на удаленном кластере

В проекте используются балансировщики Nginx на удаленном кластере:

Ollama балансировщик - работает на внешнем IP адресе, порт 11436. Балансирует запросы между несколькими инстансами Ollama. OLLAMA_BASE_URL должен указывать на этот балансировщик, например http://YOUR_EXTERNAL_IP:11436/

Reranker балансировщик - работает на внешнем IP адресе, путь /reranker/. Балансирует запросы между несколькими инстансами реранкера. RERANKER_SERVICE_URLS должен указывать на этот балансировщик, например http://YOUR_EXTERNAL_IP/reranker/

Оба балансировщика используют алгоритм least_conn для распределения нагрузки. Если один инстанс недоступен, запросы автоматически перенаправляются на другие.

## Основные файлы

RAG Chat API:
- app.py - главный файл, все роуты и логика
- proper_retriever.py - поиск документов с реранкингом
- embedding_service.py - создание векторов текста
- chroma_client.py - работа с ChromaDB
- reranker_client.py - клиент для балансировщика реранкера
- static/widget.js - JavaScript виджет для встраивания
- templates/ - HTML шаблоны для админки

Analytics:
- app.py - основной файл с API для статистики
- simple_app.py - упрощенная версия если нужна
- templates/analytics.html - дашборд со статистикой

## Что нужно знать

Модели

Система работает с Ollama через балансировщик. По умолчанию qwen3:30b, но можно любую другую. Главное чтобы понимала русский и работала с большим контекстом.

Для эмбеддингов используется jeffh/intfloat-multilingual-e5-large-instruct:q8_0. Она тоже должна быть загружена в Ollama на удаленном кластере.

OLLAMA_BASE_URL может содержать несколько URL через запятую для балансировки. Если указан балансировщик, используй его. Если несколько прямых адресов - система будет переключаться между ними при ошибках.

Документы

Загружаются через админку /admin. Поддерживаются PDF, DOCX, TXT, HTML, Markdown.

После загрузки документы парсятся, разбиваются на чанки и сохраняются в ChromaDB. Размер чанков настраивается в parser_settings.json.

ChromaDB обычно работает на внутреннем IP адресе, порт 8000. CHROMADB_BASE_URL должен указывать на него, например http://YOUR_INTERNAL_IP:8000

Виджет

Просто JavaScript файл который можно встроить на любой сайт. Сам создает интерфейс чата, подключается к API, обрабатывает ответы.

По умолчанию закрыт, открывается по клику. Есть поддержка темной/светлой темы, версия для слабовидящих.

Системный промпт

Находится в production_configs/system_prompt.txt. Это инструкции для модели - как отвечать, в каком стиле.

Можешь менять как угодно. Главное сохранить плейсхолдеры:
- {customer_notes} - замечания заказчика
- {conversation_context} - история диалога
- {context} - найденные документы
- {question} - вопрос пользователя

## Настройки

Основные настройки через переменные окружения:

OLLAMA_BASE_URL - адрес балансировщика Ollama или несколько адресов через запятую. Если балансировщик на удаленном кластере - используй его адрес с портом 11436
CHROMADB_BASE_URL - адрес ChromaDB, обычно внутренний IP с портом 8000
ANALYTICS_BASE_URL - адрес Analytics сервиса
RERANKER_SERVICE_URLS - адрес балансировщика реранкера или несколько адресов через запятую. Если балансировщик на удаленном кластере - используй его адрес с путем /reranker/
MODEL_NAME - какая модель использовать
TEMPERATURE - креативность ответов 0.0-1.0
NUM_CTX - размер контекста для модели
SEARCH_K - сколько документов искать
TIMEOUT - таймаут для запросов к Ollama

Все можно менять на лету через админку или переменные окружения.

## Производительность

Рассчитана на среднюю нагрузку. Если много пользователей одновременно:
- Поставь несколько экземпляров API за балансировщиком
- Используй Redis для кеширования частых вопросов
- Увеличь количество инстансов Ollama и реранкера на удаленном кластере

Для одного-двух пользователей работает нормально.

## Безопасность

По умолчанию CORS разрешен для всех доменов. Если нужно ограничить - меняй в app.py:

CORS(app, resources={r"/api/*": {"origins": ["https://your-domain.com"]}})

Также стоит настроить rate limiting если планируешь публичный доступ. В коде его нет, но можно добавить через Flask-Limiter.

## Логирование

Логи пишутся в stdout. Если через Docker - логи доступны через docker logs.

Уровень логирования через переменную LOG_LEVEL (DEBUG, INFO, WARNING, ERROR).

## Примеры использования

В папке examples/ есть Jupyter Notebooks с примерами:

01_basic_usage.ipynb - базовое использование API для получения ответов
02_document_management.ipynb - загрузка и управление документами
03_analytics.ipynb - работа с Analytics API

Для запуска примеров установи Jupyter и зависимости:
pip install jupyter requests pandas
jupyter notebook

## Что дальше

После развертывания:
1. Загрузи свои документы
2. Настрой системный промпт под свою тематику
3. Протестируй виджет на своем сайте
4. Следи за статистикой через Analytics
5. Изучи примеры в Jupyter Notebooks

Если что-то не работает - смотри логи. Там обычно все понятно. Если совсем ничего не помогает - разбирайся с кодом, он довольно простой.
