from flask import Flask, request, jsonify
import sqlite3
import json
import os
from datetime import datetime
app = Flask(__name__)
DATABASE_PATH = '/app/data/analytics.db'
DATA_DIR = '/app/data'
os.makedirs(DATA_DIR, exist_ok=True)
def init_database():

    try:
        conn = sqlite3.connect(DATABASE_PATH)
        cursor = conn.cursor()
        cursor.execute()
        conn.commit()
        conn.close()
        print("База данных инициализирована")
    except Exception as e:
        print(f"Ошибка инициализации базы данных: {e}")
@app.route('/api/conversations/<conversation_id>/messages', methods=['POST'])
def add_message(conversation_id):

    print(f"=== ADD MESSAGE CALLED ===")
    print(f"conversation_id: {conversation_id}")
    try:
        data = request.get_json()
        print(f"request.get_json(): {data}")
        message_type = data.get('type', 'user')
        content = data.get('content', '')
        metadata = data.get('metadata', {})
        llm_generation_time = data.get('llm_generation_time')
        print(f"Extracted: type={message_type}, content='{content}', llm_generation_time={llm_generation_time}")
        if not content:
            return jsonify({'error': 'Содержимое сообщения не может быть пустым'}), 400
        conn = sqlite3.connect(DATABASE_PATH)
        cursor = conn.cursor()
        cursor.execute('''
            INSERT INTO messages (conversation_id, message_type, content, metadata, llm_generation_time)
            VALUES (?, ?, ?, ?, ?)
        ''', (conversation_id, message_type, content, json.dumps(metadata), llm_generation_time))
        conn.commit()
        conn.close()
        print(f"SAVED: llm_generation_time={llm_generation_time}")
        return jsonify({
            'status': 'success',
            'message': 'Сообщение добавлено'
        })
    except Exception as e:
        print(f"ERROR: {e}")
        import traceback
        traceback.print_exc()
        return jsonify({'error': str(e)}), 500
@app.route('/api/stats')
def get_stats():

    try:
        conn = sqlite3.connect(DATABASE_PATH)
        cursor = conn.cursor()
        cursor.execute('SELECT COUNT(*) FROM messages')
        total_messages = cursor.fetchone()[0]
        cursor.execute('SELECT COUNT(DISTINCT conversation_id) FROM messages')
        total_conversations = cursor.fetchone()[0]
        cursor.execute('SELECT COUNT(*) FROM messages WHERE message_type = "assistant"')
        assistant_messages = cursor.fetchone()[0]
        cursor.execute('SELECT COUNT(*) FROM messages WHERE message_type = "user"')
        user_messages = cursor.fetchone()[0]
        cursor.execute('SELECT AVG(llm_generation_time), MIN(llm_generation_time), MAX(llm_generation_time), COUNT(llm_generation_time) FROM messages WHERE llm_generation_time IS NOT NULL')
        time_stats = cursor.fetchone()
        conn.close()
        return jsonify({
            'status': 'success',
            'stats': {
                'total_messages': total_messages,
                'total_conversations': total_conversations,
                'assistant_messages': assistant_messages,
                'user_messages': user_messages,
                'llm_generation_time': {
                    'avg': time_stats[0],
                    'min': time_stats[1],
                    'max': time_stats[2],
                    'count': time_stats[3]
                }
            }
        })
    except Exception as e:
        print(f"ERROR in stats: {e}")
        return jsonify({'error': str(e)}), 500
if __name__ == '__main__':
    init_database()
    print("Запускаем простую аналитику...")
    app.run(host='0.0.0.0', port=9005, debug=True)