# 🔧 DEV ОКРУЖЕНИЕ - ВСЕ ПЕРЕМЕННЫЕ

## 📋 ОБЗОР

Этот документ содержит полный список всех переменных окружения, используемых в development ветке проекта Autogen.

**Основной файл конфигурации**: `/opt/autogen/development/configs/development.env`  
**Docker Compose**: `/opt/autogen/development/docker-compose.dev.yml`  
**Settings JSON**: `/opt/autogen/settings.dev.json`  
**Проект**: `COMPOSE_PROJECT_NAME=autogen-dev`

---

## 🌍 ОКРУЖЕНИЕ И ОБЩИЕ НАСТРОЙКИ

| Переменная | Значение | Описание | Используется в |
|------------|----------|----------|----------------|
| `ENVIRONMENT` | `development` | Окружение (development/production) | app.py, все сервисы |
| `DEBUG` | `True` | Режим отладки | Flask приложения |
| `LOG_LEVEL` | `DEBUG` | Уровень логирования | Все сервисы |
| `COMPOSE_PROJECT_NAME` | `autogen-dev` | Имя проекта Docker Compose | docker-compose.dev.yml |
| `COMPOSE_PATH` | `/opt/autogen/development` | Путь к docker-compose файлам | app.py (управление контейнерами) |

---

## 🤖 OLLAMA КОНФИГУРАЦИЯ

| Переменная | Значение | Описание | Используется в |
|------------|----------|----------|----------------|
| `OLLAMA_BASE_URL` | `http://YOUR_EXTERNAL_IP:11436/` | Базовый URL Ollama (через Nginx балансировщик) | app.py, embedding_service.py |
| `OLLAMA_HOST` | `YOUR_EXTERNAL_IP` | Хост Ollama сервера | app.py |
| `OLLAMA_PORT` | `11436` | Порт Ollama сервера | app.py |
| `MODEL_NAME` | `gpt-oss:latest` | Основная LLM модель | app.py, settings.dev.json |
| `EMBEDDING_MODEL` | `jeffh/intfloat-multilingual-e5-large-instruct:q8_0` | Модель для создания эмбеддингов | app.py, embedding_service.py |
| `TEMPERATURE` | `0.2` | Температура генерации (креативность) | app.py |
| `NUM_CTX` | `50000` | Размер контекстного окна (в development.env) | app.py |
| `NUM_CTX` | `128000` | Размер контекстного окна (в settings.dev.json) | app.py |
| `SEARCH_K` | `50` | Количество документов для поиска | app.py |
| `TIMEOUT` | `600` | Таймаут запросов к Ollama (секунды) | app.py |
| `OLLAMA_KEEP_ALIVE` | `12h` | Время удержания модели в памяти | app.py, embedding_service.py |
| `KEEP_ALIVE` | (не задано) | Альтернативное имя для OLLAMA_KEEP_ALIVE | app.py |
| `THINK_LEVEL` | `low` | Уровень размышлений ("high", "medium", "low", true, false) | app.py |
| `NUM_PREDICT` | `4000` | Максимальное количество токенов для генерации | app.py |
| `REPEAT_PENALTY` | `1.3` | Штраф за повторения (предотвращает зацикливание) | app.py |
| `STOP_WORDS` | `["\\n\\n\\n\\n", "Ответ:", "Вопрос:", "Размышление завершено"]` | Stop слова для Ollama (JSON массив) | app.py |
| `MAX_CONCURRENT` | `22` | Максимальное количество одновременных запросов | app.py |
| `OLLAMA_POOL_CONNECTIONS` | `20` | Размер пула соединений для Ollama | app.py |
| `OLLAMA_POOL_MAXSIZE` | `100` | Максимальный размер пула соединений | app.py |

### Примечания:
- `OLLAMA_BASE_URL` может содержать несколько URL через запятую для балансировки
- `THINK_LEVEL` может быть строкой ("high", "medium", "low") или булевым значением
- `STOP_WORDS` парсится как JSON массив из строки

---

## 🔍 EMBEDDING КОНФИГУРАЦИЯ

| Переменная | Значение | Описание | Используется в |
|------------|----------|----------|----------------|
| `EMBEDDING_TIMEOUT` | `120` | Таймаут для создания эмбеддингов (секунды) | embedding_service.py |
| `EMBEDDING_MAX_RETRIES` | `3` | Максимальное количество попыток | embedding_service.py |
| `EMBEDDING_RETRY_DELAY` | `1.0` | Задержка между попытками (секунды) | embedding_service.py |
| `EMBEDDING_MAX_WORKERS` | `8` | Количество параллельных потоков для создания эмбеддингов | embedding_service.py |
| `EMBEDDING_BATCH_SIZE` | `20` | Размер батча для обработки эмбеддингов | embedding_service.py |

### Примечания:
- Рекомендуется: 4-8 workers для CPU, 8-16 для GPU
- Больший batch_size = быстрее, но больше памяти

---

## 🎯 RERANKER КОНФИГУРАЦИЯ

| Переменная | Значение | Описание | Используется в |
|------------|----------|----------|----------------|
| `RERANKER_MODEL` | `BAAI/bge-reranker-base` | Модель для реранкинга | reranker_api.py, proper_retriever.py |
| `RERANKER_SERVICE_URLS` | `http://YOUR_EXTERNAL_IP/reranker/` | URL балансировщика реранкера (Nginx) | reranker_client.py, app.py |
| `RERANKER_TIMEOUT` | `60` | Таймаут запросов к реранкеру (секунды) | reranker_client.py |
| `RERANKER_PORT` | `9010` | Порт reranker сервиса | docker-compose.dev.yml |
| `RERANKER_BATCH_SIZE` | `64` | Размер батча для реранкинга | reranker_api.py, proper_retriever.py |
| `RERANKER_MAX_DOCS` | `20` | Максимум документов для реранкинга (по умолчанию: 20, 30 или 100 в разных местах) | proper_retriever.py, reranker_api.py |
| `LOCAL_RERANKER_URL` | `http://autogen-dev-reranker:80` | URL локального reranker для fallback | proper_retriever.py |

### Примечания:
- `RERANKER_SERVICE_URLS` используется для балансировки нагрузки
- `LOCAL_RERANKER_URL` используется как fallback через Docker сеть
- Reranker поддерживает ONNX для ускорения (2-3x быстрее на CPU)
- `RERANKER_MAX_DOCS` и `RERANKER_BATCH_SIZE` могут парситься с комментариями (берется только число до `#`)
- `RERANKER_MAX_DOCS` имеет разные значения по умолчанию в разных местах:
  - В `development.env`: `20`
  - В `proper_retriever.py`: `30` или `100` (в зависимости от функции)
  - В `reranker_api.py`: `20`

---

## 🗄️ БАЗЫ ДАННЫХ КОНФИГУРАЦИЯ

| Переменная | Значение | Описание | Используется в |
|------------|----------|----------|----------------|
| `CHROMADB_BASE_URL` | `http://YOUR_INTERNAL_IP:8000` | Базовый URL ChromaDB | app.py, chroma_client.py |
| `CHROMADB_HOST` | `YOUR_INTERNAL_IP` | Хост ChromaDB | app.py, chroma_client.py |
| `CHROMADB_PORT` | `8000` | Порт ChromaDB | app.py, chroma_client.py |
| `CHROMADB_COLLECTION_NAME` | `shared_documents_cosine` | Имя коллекции в ChromaDB | chroma_client.py |
| `ANONYMIZED_TELEMETRY` | `False` | Отключение телеметрии ChromaDB (устанавливается в коде) | chroma_client.py |
| `CHROMA_SERVER_HOST` | `0.0.0.0` | Хост ChromaDB сервера (задается в docker-compose) | docker-compose.dev.yml |
| `CHROMA_SERVER_HTTP_PORT` | `8000` | HTTP порт ChromaDB сервера (задается в docker-compose) | docker-compose.dev.yml |
| `CHROMA_SERVER_DATA_PATH` | `/data` | Путь к данным ChromaDB (задается в docker-compose) | docker-compose.dev.yml |
| `ANALYTICS_BASE_URL` | `http://dev-analytics:9005` | Базовый URL Analytics (внутренний) | app.py |
| `ANALYTICS_HOST` | `dev-analytics` | Хост Analytics сервиса | app.py |
| `ANALYTICS_PORT` | `9005` | Порт Analytics сервиса | app.py |
| `DATA_DIR` | `/app/data` | Директория для данных | analytics/app.py |
| `DATABASE_PATH` | `/app/data/analytics.db` | Путь к базе данных аналитики | analytics/app.py |

### Примечания:
- ChromaDB использует коллекцию `shared_documents_cosine` с cosine distance
- Analytics использует SQLite базу данных
- `ANALYTICS_BASE_URL` используется для внутренней коммуникации через Docker сеть
- `ANONYMIZED_TELEMETRY` устанавливается программно в `chroma_client.py`, не задается в .env
- `CHROMA_SERVER_HOST`, `CHROMA_SERVER_HTTP_PORT`, `CHROMA_SERVER_DATA_PATH` задаются напрямую в docker-compose.dev.yml для контейнера shared-chromadb

---

## 🌐 FLASK КОНФИГУРАЦИЯ

| Переменная | Значение | Описание | Используется в |
|------------|----------|----------|----------------|
| `FLASK_HOST` | `0.0.0.0` | Хост Flask приложения | app.py |
| `FLASK_PORT` | `9004` | Порт Flask приложения (внутренний) | app.py |
| `FLASK_DEBUG` | `True` | Режим отладки Flask | app.py |
| `DEV_API_PORT` | `9008` | Порт для внешнего доступа к API | docker-compose.dev.yml |

### Примечания:
- Внутренний порт: 9004
- Внешний порт (маппинг): 9008 → 9004

---

## 🔐 БЕЗОПАСНОСТЬ КОНФИГУРАЦИЯ

| Переменная | Значение | Описание | Используется в |
|------------|----------|----------|----------------|
| `SECRET_KEY` | `development_secret_key` | Секретный ключ для Flask | app.py |
| `CORS_ORIGINS` | `http://localhost:9008,https://dev.your-rag-chat-api.com` | Разрешенные источники для CORS | app.py |

---

## 🌍 ДОМЕНЫ КОНФИГУРАЦИЯ

| Переменная | Значение | Описание | Используется в |
|------------|----------|----------|----------------|
| `WIDGET_DOMAIN` | `https://dev.your-rag-chat-api.com` | Домен для виджета | app.py |
| `API_DOMAIN` | `https://dev.your-rag-chat-api.com` | Домен для API | app.py |
| `ANALYTICS_DOMAIN` | `http://YOUR_INTERNAL_IP:9005` | Домен для аналитики | app.py |

---

## ⚡ ПРОИЗВОДИТЕЛЬНОСТЬ КОНФИГУРАЦИЯ

| Переменная | Значение | Описание | Используется в |
|------------|----------|----------|----------------|
| `MAX_CONNECTIONS` | `50` | Максимальное количество соединений | app.py |
| `CONNECTION_TIMEOUT` | `15` | Таймаут соединения (секунды) | app.py |
| `REQUEST_TIMEOUT` | `60` | Таймаут запроса (секунды) | app.py |

---

## 🐳 DOCKER КОНТЕЙНЕРЫ КОНФИГУРАЦИЯ

| Переменная | Значение | Описание | Используется в |
|------------|----------|----------|----------------|
| `RAG_CHAT_CONTAINER` | `autogen-dev-rag-chat-api` | Имя контейнера RAG Chat API | app.py |
| `OLLAMA_CONTAINER` | `shared-ollama` | Имя контейнера Ollama (не используется, Ollama внешний) | app.py |
| `CHROMADB_CONTAINER` | `shared-chromadb` | Имя контейнера ChromaDB | app.py |
| `ANALYTICS_CONTAINER` | `autogen-dev-analytics` | Имя контейнера Analytics | app.py |

---

## 📄 СИСТЕМНЫЙ ПРОМПТ КОНФИГУРАЦИЯ

| Переменная | Значение | Описание | Используется в |
|------------|----------|----------|----------------|
| `SYSTEM_PROMPT_PATH` | (не задано) | Путь к файлу системного промпта (опционально) | app.py |

### Примечания:
- По умолчанию используется `/opt/autogen/development/configs/system_prompt.txt`
- Если `SYSTEM_PROMPT_PATH` задан и файл существует, используется он
- Системный промпт загружается в переменную `CUSTOMER_PROMPT` в app.py

### Примечания:
- `OLLAMA_CONTAINER` не используется, так как Ollama находится на внешнем сервере
- Все контейнеры имеют префикс `autogen-dev-` для изоляции

---

## 📊 DOCKER COMPOSE ПЕРЕМЕННЫЕ

### Порты (с дефолтными значениями):
- `${DEV_API_PORT:-9008}:${FLASK_PORT:-9004}` - маппинг портов для RAG Chat API
- `${ANALYTICS_PORT:-9005}:${ANALYTICS_PORT:-9005}` - маппинг портов для Analytics

### Networks:
- `autogen-dev-rag-network` - основная сеть для RAG компонентов
- `autogen-dev-network` - дополнительная сеть для изоляции
- `reverse_reverse-network` - внешняя сеть для reverse proxy

### Volumes:
- `dev_data:/app/data` - данные приложения
- `dev_analytics_data:/app/data` - данные аналитики (именованный: `autogen_dev_analytics_data`)
- `/opt/autogen/chroma_db:/data` - данные ChromaDB (host mount)

---

## 📝 SETTINGS.JSON КОНФИГУРАЦИЯ

Файл `/opt/autogen/settings.dev.json` содержит следующие переменные:

```json
{
  "model": "gpt-oss:latest",
  "embedding_model": "jeffh/intfloat-multilingual-e5-large-instruct:q8_0",
  "temperature": 0.2,
  "num_ctx": 128000,
  "search_k": 50,
  "timeout": 600,
  "think_level": "low",
  "ollama_url": "http://YOUR_EXTERNAL_IP:11436/",
  "chromadb_url": "http://YOUR_INTERNAL_IP:8000",
  "analytics_url": "http://dev-analytics:9005",
  "reranker_service_urls": "http://YOUR_EXTERNAL_IP/reranker/",
  "widget_domain": "https://dev.your-rag-chat-api.com",
  "api_domain": "https://dev.your-rag-chat-api.com",
  "analytics_domain": "http://YOUR_INTERNAL_IP:9005",
  "analytics_host": "dev-analytics",
  "analytics_port": 9005,
  "updated_at": "2025-11-25T12:38:33.330377"
}
```

### Примечания:
- Settings.json используется как резервный источник конфигурации
- Приоритет: переменные окружения > settings.json > значения по умолчанию
- `num_ctx` в settings.json (128000) отличается от development.env (50000)

---

## 🔄 ПРИОРИТЕТ ЗАГРУЗКИ ПЕРЕМЕННЫХ

1. **Переменные окружения** (высший приоритет)
   - Загружаются из `development.env` через `env_file` в docker-compose
   - Могут быть переопределены через `environment` в docker-compose
   - Используются напрямую через `os.getenv()`

2. **Settings JSON** (средний приоритет)
   - Загружаются из `/opt/autogen/settings.dev.json`
   - Используются как fallback если переменная окружения не задана

3. **Значения по умолчанию** (низший приоритет)
   - Хардкод в коде через `os.getenv('VAR', 'default')`
   - Используются только если переменная не задана нигде

---

## 📂 ФАЙЛЫ КОНФИГУРАЦИИ

### Основные файлы:
1. `/opt/autogen/development/configs/development.env` - основной файл переменных окружения
2. `/opt/autogen/development/.env` - COMPOSE_PROJECT_NAME
3. `/opt/autogen/development/docker-compose.dev.yml` - Docker Compose конфигурация
4. `/opt/autogen/settings.dev.json` - JSON конфигурация

### Файлы, использующие переменные:
- `development/app/app.py` - основное Flask приложение
- `development/app/embedding_service.py` - сервис эмбеддингов
- `development/app/chroma_client.py` - клиент ChromaDB
- `development/app/reranker_client.py` - клиент реранкера
- `development/app/proper_retriever.py` - ретривер документов
- `development/analytics/app.py` - сервис аналитики
- `development/reranker_service/reranker_api.py` - API реранкера

---

## 🎯 КЛЮЧЕВЫЕ ОСОБЕННОСТИ

### 1. Балансировка нагрузки:
- **Ollama**: через Nginx балансировщик на `YOUR_EXTERNAL_IP:11436`
- **Reranker**: через Nginx балансировщик на `YOUR_EXTERNAL_IP/reranker/`

### 2. Изоляция окружений:
- Префикс `autogen-dev-` для всех контейнеров
- Уникальные сети: `autogen-dev-rag-network`, `autogen-dev-network`
- Отдельный COMPOSE_PROJECT_NAME: `autogen-dev`

### 3. GPU поддержка:
- RAG Chat API имеет доступ к GPU для ускорения CrossEncoder
- Конфигурация в docker-compose: `deploy.resources.reservations.devices`

### 4. Healthchecks:
- RAG Chat API: `http://localhost:9004/api/status`
- Analytics: `http://localhost:9005/api/stats`
- Reranker: `http://localhost:9010/health`

---

## 📊 СВОДНАЯ ТАБЛИЦА ВСЕХ ПЕРЕМЕННЫХ

| Категория | Количество переменных |
|-----------|----------------------|
| Окружение и общие | 5 |
| Ollama | 16 |
| Системный промпт | 1 |
| Embedding | 5 |
| Reranker | 7 |
| Базы данных | 12 |
| Flask | 4 |
| Безопасность | 2 |
| Домены | 3 |
| Производительность | 3 |
| Docker контейнеры | 4 |
| **ИТОГО** | **61 переменная** |

---

## 🔍 ПОИСК ПЕРЕМЕННЫХ В КОДЕ

Для поиска использования переменных в коде:
```bash
grep -r "os.getenv\|os.environ" /opt/autogen/development/
```

Основные места использования:
- `app.py`: ~50 использований `os.getenv()`
- `embedding_service.py`: ~5 использований
- `chroma_client.py`: ~3 использования
- `reranker_client.py`: ~3 использования
- `proper_retriever.py`: ~10 использований
- `analytics/app.py`: минимальное использование (хардкод путей)

---

## ⚠️ ВАЖНЫЕ ЗАМЕЧАНИЯ

1. **Конфликт NUM_CTX**: 
   - В `development.env`: `NUM_CTX=50000`
   - В `settings.dev.json`: `num_ctx=128000`
   - Приоритет у переменной окружения

2. **Reranker порт**:
   - Healthcheck проверяет порт `9010`
   - Но сервис может работать на порту `80` внутри контейнера
   - Нужно проверить конфигурацию

3. **ChromaDB коллекция**:
   - Используется `shared_documents_cosine` (cosine distance)
   - Размерность эмбеддингов: 1024 (из модели `jeffh/intfloat-multilingual-e5-large-instruct`)

4. **Ollama Keep Alive**:
   - Формат: `12h` (12 часов)
   - Парсится функцией `parse_keep_alive()` в app.py
   - Может быть задан как `OLLAMA_KEEP_ALIVE` или `KEEP_ALIVE`
   - Поддерживает форматы: "12h", "30m", "3600" (секунды), "1h30m"

5. **Системный промпт**:
   - По умолчанию: `/opt/autogen/development/configs/system_prompt.txt`
   - Может быть переопределен через `SYSTEM_PROMPT_PATH`
   - Загружается в переменную `CUSTOMER_PROMPT` при старте приложения

---

**Последнее обновление**: 2025-01-XX  
**Версия документа**: 1.0  
**Статус**: Полный список всех переменных dev окружения

