# 🩸 Autogen - RAG-чатбот для службы крови

Интеллектуальная система на базе RAG (Retrieval-Augmented Generation) для консультирования по вопросам донорства крови.

## 📋 Описание

**Autogen** - это медицинский RAG-чатбот, который предоставляет точные и актуальные ответы на вопросы о донорстве крови, используя:
- **LLM (Ollama)** для генерации ответов
- **ChromaDB** для векторного поиска документов
- **Embedding Service** для создания векторных представлений текста
- **Reranker Service** для улучшения релевантности найденных документов
- **Analytics Service** для сбора статистики диалогов

## 🏗️ Архитектура

```
┌─────────────────────────────────────────────────────────────┐
│                    AUTOGEN PROJECT                          │
│              (Медицинский RAG для службы крови)              │
├─────────────────────────────────────────────────────────────┤
│                                                              │
│  ┌──────────────┐    ┌──────────────┐    ┌──────────────┐ │
│  │ RAG Chat API │───▶│  Embedding   │───▶│   Ollama     │ │
│  │  (Flask)     │    │   Service    │    │  (External)  │ │
│  └──────┬───────┘    └──────────────┘    └──────────────┘ │
│         │                                                  │
│         ├──────────────┐                                   │
│         │              │                                   │
│  ┌──────▼───────┐  ┌──▼──────────┐  ┌──────────────┐    │
│  │  ChromaDB    │  │   Reranker  │  │  Analytics   │    │
│  │  (Vector DB) │  │   Service   │  │   Service    │    │
│  └──────────────┘  └─────────────┘  └──────────────┘    │
│                                                           │
└───────────────────────────────────────────────────────────┘
```

## 📁 Структура проекта

```
/opt/autogen/
├── development/          # Development окружение
│   ├── app/              # Основное Flask приложение
│   ├── analytics/        # Сервис аналитики
│   ├── reranker_service/ # Микросервис реранкинга
│   ├── configs/          # Конфигурационные файлы
│   └── docker-compose.dev.yml
├── production/          # Production окружение
│   ├── app/
│   ├── analytics/
│   ├── reranker_service/
│   ├── configs/
│   └── docker-compose.production.yml
├── studio-app/          # Studio приложение (долбильня виджетов)
├── whisper-speech/      # Сервис распознавания речи
├── localai-speech/      # Альтернативный сервис речи
└── docs/                # Документация
```

## 🚀 Быстрый старт

### Требования

- Docker и Docker Compose
- Python 3.9+
- Доступ к Ollama серверу

### Development окружение

```bash
cd /opt/autogen/development
docker-compose -f docker-compose.dev.yml up -d
```

### Production окружение

```bash
cd /opt/autogen/production
docker-compose -f docker-compose.production.yml up -d
```

## 🌐 Домены и порты

### Development
- **Dev API**: `https://dev.your-rag-chat-api.com` (порт 9008 → 9004)
- **Analytics**: `http://YOUR_INTERNAL_IP:9005` (порт 9005)
- **ChromaDB**: `http://YOUR_INTERNAL_IP:8000` (порт 8000)
- **Reranker**: `http://YOUR_INTERNAL_IP:9010` (порт 9010)

### Production
- **Prod API**: `https://your-rag-chat-api.com` (порт 9004)
- **Analytics**: `https://your-analytics.com` (порт 9006)

## 🔧 Конфигурация

### Переменные окружения

Основные конфигурационные файлы:
- `development/configs/development.env` - переменные для dev окружения
- `production/configs/production.env` - переменные для prod окружения

**⚠️ ВАЖНО**: Файлы `.env` не должны попадать в репозиторий! Используйте `.env.example` как шаблон.

### Настройка Ollama

```env
OLLAMA_BASE_URL=http://YOUR_EXTERNAL_IP:11436/
MODEL_NAME=gpt-oss:latest
EMBEDDING_MODEL=jeffh/intfloat-multilingual-e5-large-instruct:q8_0
```

### Настройка ChromaDB

```env
CHROMADB_BASE_URL=http://YOUR_INTERNAL_IP:8000
CHROMADB_HOST=YOUR_INTERNAL_IP
CHROMADB_PORT=8000
```

## 📚 Документация

- [DEV_ENV_VARIABLES.md](DEV_ENV_VARIABLES.md) - Полный список переменных окружения
- [TODO.md](TODO.md) - Список задач и анализ проекта
- [docs/](docs/) - Дополнительная документация

## 🧪 Тестирование

### Studio App (Долбильня виджетов)

Инструмент для массового тестирования виджетов:
- Доступ: через studio-app
- Функции: генерация вопросов, отправка во все виджеты, оценка ответов

## 🐳 Docker

### Сборка образов

```bash
# Development
cd development
docker-compose -f docker-compose.dev.yml build

# Production
cd production
docker-compose -f docker-compose.production.yml build
```

### Управление контейнерами

```bash
# Запуск
docker-compose up -d

# Остановка
docker-compose down

# Просмотр логов
docker-compose logs -f

# Перезапуск сервиса
docker-compose restart rag-chat-api
```

## 🔒 Безопасность

- **Не коммитьте** файлы с секретами (`.env`, `*.key`, `*.pem`)
- Используйте переменные окружения GitLab CI/CD для секретов
- Регулярно обновляйте зависимости
- Используйте HTTPS в production

## 🤝 Вклад в проект

1. Создайте ветку для вашей функции (`git checkout -b feature/amazing-feature`)
2. Внесите изменения и закоммитьте (`git commit -m 'Add amazing feature'`)
3. Запушьте в ветку (`git push origin feature/amazing-feature`)
4. Создайте Merge Request в GitLab

## 📝 Лицензия

[Укажите лицензию проекта]

## 👥 Авторы

[Укажите авторов проекта]

## 📞 Контакты

[Укажите контактную информацию]

---

**Примечание**: Этот проект находится в активной разработке. API и конфигурация могут изменяться.


