# 🩸 Autogen Production - RAG-чатбот для службы крови

Production окружение медицинского RAG-чатбота для консультирования по вопросам донорства крови.

## 📋 Описание

**Autogen Production** - это production окружение интеллектуальной RAG (Retrieval-Augmented Generation) системы, которая предоставляет точные и актуальные ответы на вопросы о донорстве крови в production среде.

### Основные компоненты:
- **RAG Chat API** (Flask) - основное приложение
- **ChromaDB** - векторная база данных для документов
- **Embedding Service** - создание векторных представлений текста
- **Reranker Service** - улучшение релевантности найденных документов
- **Analytics Service** - сбор статистики диалогов

## 🏗️ Архитектура

```
┌─────────────────────────────────────────────────────────────┐
│             AUTOGEN PRODUCTION ENVIRONMENT                  │
├─────────────────────────────────────────────────────────────┤
│                                                              │
│  ┌──────────────┐    ┌──────────────┐    ┌──────────────┐ │
│  │ RAG Chat API │───▶│  Embedding   │───▶│   Ollama     │ │
│  │  (Flask)     │    │   Service    │    │  (External)  │ │
│  │  :9004       │    │              │    │  :11436      │ │
│  └──────┬───────┘    └──────────────┘    └──────────────┘ │
│         │                                                  │
│         ├──────────────┐                                   │
│         │              │                                   │
│  ┌──────▼───────┐  ┌──▼──────────┐  ┌──────────────┐    │
│  │  ChromaDB    │  │   Reranker  │  │  Analytics   │    │
│  │  (Vector DB) │  │   Service   │  │   Service    │    │
│  │  :8000       │  │   :9010     │  │   :9006      │    │
│  └──────────────┘  └─────────────┘  └──────────────┘    │
│                                                           │
└───────────────────────────────────────────────────────────┘
```

## 🚀 Быстрый старт

### Требования

- Docker и Docker Compose
- Доступ к Ollama серверу
- SSL сертификаты для HTTPS

### Запуск

```bash
cd /opt/autogen/production
docker-compose -f docker-compose.production.yml up -d
```

### Проверка статуса

```bash
docker-compose -f docker-compose.production.yml ps
```

## 🌐 Домены и порты

- **Prod API**: `https://your-rag-chat-api.com` (порт 9004)
- **Analytics**: `https://your-analytics.com` (порт 9006)
- **ChromaDB**: внутренний доступ через Docker сеть
- **Reranker**: внутренний доступ через Docker сеть

## 📁 Структура проекта

```
production/
├── app/                    # Основное Flask приложение
│   ├── app.py             # Главный файл приложения
│   ├── embedding_service.py # Сервис создания эмбеддингов
│   ├── chroma_client.py    # Клиент для работы с ChromaDB
│   ├── proper_retriever.py # Ретривер с гибридным поиском
│   ├── reranker_client.py  # Клиент для сервиса реранкинга
│   ├── document_parsers.py # Парсеры документов
│   ├── templates/          # HTML шаблоны
│   └── static/             # Статические файлы
├── analytics/              # Сервис аналитики
│   ├── app.py             # Flask приложение аналитики
│   └── templates/         # HTML шаблоны аналитики
├── reranker_service/       # Микросервис реранкинга
│   ├── reranker_api.py    # Flask API для реранкинга
│   └── Dockerfile         # Docker образ
├── configs/               # Конфигурационные файлы
│   ├── production.env     # Переменные окружения
│   └── system_prompt.txt  # Системный промпт для LLM
└── docker-compose.production.yml # Docker Compose конфигурация
```

## 🔧 Конфигурация

### Переменные окружения

Основной файл конфигурации: `configs/production.env`

**⚠️ ВАЖНО**: Файл `.env` не должен попадать в репозиторий!

### Основные настройки

```env
# Environment
ENVIRONMENT=production
DEBUG=False
LOG_LEVEL=INFO

# Ollama
OLLAMA_BASE_URL=http://YOUR_EXTERNAL_IP:11436/
MODEL_NAME=gpt-oss:latest
EMBEDDING_MODEL=jeffh/intfloat-multilingual-e5-large-instruct:q8_0

# Security
SECRET_KEY=<production-secret-key>
CORS_ORIGINS=https://your-rag-chat-api.com
```

## 🐳 Docker

### Управление контейнерами

```bash
# Запуск
docker-compose -f docker-compose.production.yml up -d

# Остановка
docker-compose -f docker-compose.production.yml down

# Просмотр логов
docker-compose -f docker-compose.production.yml logs -f

# Перезапуск сервиса
docker-compose -f docker-compose.production.yml restart rag-chat-api
```

## 🔒 Безопасность Production

### Рекомендации:

1. **SSL/TLS**: Используйте HTTPS для всех соединений
2. **Секреты**: Храните секреты в переменных окружения, не в коде
3. **Логирование**: Настройте централизованное логирование
4. **Мониторинг**: Используйте мониторинг и алерты
5. **Бэкапы**: Регулярно делайте бэкапы базы данных
6. **Обновления**: Регулярно обновляйте зависимости

## 📊 Мониторинг

### Health Checks

```bash
# API Health
curl https://your-rag-chat-api.com/api/health

# Analytics Health
curl https://your-analytics.com/api/stats
```

### Логи

```bash
# Просмотр логов
docker-compose -f docker-compose.production.yml logs -f rag-chat-api

# Логи за последний час
docker-compose -f docker-compose.production.yml logs --since 1h rag-chat-api
```

## 🔄 Деплой

### Процесс деплоя:

1. Обновить код из репозитория
2. Обновить переменные окружения (если нужно)
3. Пересобрать образы (если нужно)
4. Перезапустить контейнеры
5. Проверить работоспособность

```bash
cd /opt/autogen/production
git pull
docker-compose -f docker-compose.production.yml up -d --build
```

## 📚 Документация

- [app/PROBLEMS_REGISTRY.md](app/PROBLEMS_REGISTRY.md) - Реестр проблем
- [app/TODO.md](app/TODO.md) - Список задач
- [../DEV_ENV_VARIABLES.md](../DEV_ENV_VARIABLES.md) - Переменные окружения

## 🎯 Отличия от Development

- **Debug режим**: выключен
- **Логирование**: только важные события
- **Производительность**: оптимизировано для production
- **Безопасность**: усиленные меры безопасности
- **Мониторинг**: расширенный мониторинг и алерты

---

## 🔗 Ссылки

- **Вики проекта**: [Артемопедия - Autogen Prod](https://nolyan.your-domain.com/wiki/project/autogen-prod)
- **GitLab**: [https://gitlab.your-domain.com/root/autogen-prod](https://gitlab.your-domain.com/root/autogen-prod)

---

## 👥 Авторы и права

**Разработка**: Девочка-волшебник, которая колдует код  
**Права на ПО**: Артем  
**Трейдмарка**: Артем Инвест

---

**Статус**: ✅ Production Ready  
**Версия**: 1.0  
**Последнее обновление**: 2025-11-29

