# Примеры использования RAG Chat API

Jupyter Notebooks с примерами работы с API.

## Быстрый старт

Просто запусти скрипт:

```bash
cd examples
./setup_and_run.sh
```

Скрипт автоматически создаст виртуальное окружение, установит зависимости и запустит Jupyter Notebook.

Пароль по умолчанию: `jupyter`

Если хочешь изменить пароль - отредактируй переменную JUPYTER_PASSWORD в скрипте setup_and_run.sh

## Ручная установка

Если хочешь сделать вручную:

```bash
python3 -m venv venv
source venv/bin/activate  # на Windows: venv\Scripts\activate
pip install -r requirements.txt
jupyter notebook
```

Или через JupyterLab:

```bash
jupyter lab
```

## Доступные примеры

01_basic_usage.ipynb - базовое использование API для получения ответов на вопросы

02_document_management.ipynb - загрузка и управление документами

03_analytics.ipynb - работа с Analytics API для получения статистики

## Настройка

Перед запуском примеров измените URL в ноутбуках:

- API_URL - адрес вашего RAG Chat API (по умолчанию http://localhost:9004)
- ANALYTICS_URL - адрес вашего Analytics сервиса (по умолчанию http://localhost:9005)

## Дополнительные примеры

Можешь создать свои ноутбуки для:
- Тестирования различных моделей
- Анализа качества ответов
- Массовой загрузки документов
- Экспорта данных из Analytics

